//AIM:To design Butterworth low pass filter with 3dB ripple and plot response of filter.
//Software version Scilab 5.5.2
//OS Windows 7

clc;
clear;
f=2;//f=normalized frequency.
IL=20;//IL is the insertion loss (in dB).
E=10^0.3-1;
N=0.5*(log(10^(0.1*IL)-1)/log((f)+log(E)));
A=N-int(N);
if(A>0)
    N=int(N)+1;
end;
disp(N,"Order of filter=")
printf("values of filter element are\n")
for i=1:N
    g(i)=2*sin((((i*2)-1)*%pi)/(2*N));
    printf("g(%g)=%g\n",i,g)
end

//IL=10log(1+(f)^2*N)
//Now ploting IL Vs normalized frequency graph.
f=0:0.1:5;
IL=10*log10(1+f.^(2*N));
title('Response of Butterworth low pass filter in terms of ''Insertion-loss(IL) versus frequency'' ');
ylabel("IL in dB");
xlabel("normalized frequency");
plot2d(f,IL);
//representing values of IL in console.
f=0:0.5:5;
IL=10*log10(1+f.^(2*N));
disp(IL,"IL in dB",f,"normalized frequency")
